<?php require_once __DIR__ . '/config.php'; ?>
<!DOCTYPE html>
<html lang="<?php echo htmlspecialchars($language ?? 'en'); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-Frame-Options" content="DENY">
    
    <title><?php echo htmlspecialchars($pageTitle ?? 'DHL'); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>

    <link rel="icon" type="image/png" href="/static/img/icon.png">
</head>
<body class="bg-gray-100 font-sans">
    <header class="bg-white shadow">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-4 flex items-center justify-between">
            <img src="/static/img/logo.png" alt="DHL Logo" class="h-12">
            <nav>
                <ul class="flex space-x-4">
                    <li><a href="/" class="text-gray-600 hover:text-red-600"><?php echo $translations[$language]['home']; ?></a></li>
                    <li><a href="/privacy" class="text-gray-600 hover:text-red-600"><?php echo $translations[$language]['privacy']; ?></a></li>
                </ul>
            </nav>
        </div>
    </header>
    <main class="min-h-screen">
        <?php if (!empty($_SESSION['flash_message'])): ?>
            <div class="max-w-2xl mx-auto mt-4">
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative" role="alert">
                    <span class="block sm:inline"><?php echo htmlspecialchars($_SESSION['flash_message']); ?></span>
                </div>
                <?php unset($_SESSION['flash_message']); ?>
            </div>
        <?php endif; ?>
